(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     42229,        852]*)
(*NotebookOutlinePosition[     42913,        876]*)
(*  CellTagsIndexPosition[     42869,        872]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Vorschlag f\[UDoubleDot]r Module", "Title"],

Cell["\<\
von Rolf Wirz  -  Version 15.2.2001  -  Copyright by Rolf Wirz\
\>", "Subsubtitle"],

Cell[CellGroupData[{

Cell["Alle Daten l\[ODoubleDot]schen, Neubeginn:", "Section"],

Cell[BoxData[
    \(\(\( (*Old\ \(Form : 
          Remove["\<Global`@*\>"]\)*) \)\(\ \ \ \
\)\(\[IndentingNewLine]\)\(\(putz = 
          Remove["\<Global`*\>"];\) (*\ "\<Putzmaschine\>"\ *) \ ;\)\)\)], \
"Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Die Modulsammlung, alle Funktionen in einer Zelle definiert, in einem Schritt \
aktivierbar.
Die Sammlung MUSS AKTIVIERT SEIN, damit die Initialisierungen laufen k\
\[ODoubleDot]nnen!\
\>", "Section"],

Cell[BoxData[{
    \( (*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\)\(=\)*) \
\[IndentingNewLine] (*\ 
      Standartwerte\ \[CurlyPhi]\ von\ Biel\ in\ Altgrad\ , \ 
      g\  = \ 1\ *) \[IndentingNewLine] (*\(\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\)\(=\)*) \[IndentingNewLine]\(dataEntryFixData = 
        Module[{}, \[IndentingNewLine]m0 = \((356.5399 - 
                  360)\)\ Degree; \ \[IndentingNewLine]e = 
            0.0167092; \[IndentingNewLine]L0 = \((282.9399 - 
                  360)\)\ Degree; \ \[IndentingNewLine]Eps\  = \ 
            23.4393\ Degree; \[IndentingNewLine]L01 = 
            0.0000470684\ Degree; \[IndentingNewLine]m01 = 
            0.9856002664\ Degree; \[IndentingNewLine]Print["\<OUT-Variabeln: \
m0, e, L0, Eps, L01, m01\>"];];\)\[IndentingNewLine] \
(*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\)\(=\)*) \), "\
\[IndentingNewLine]", 
    \(\(dataEntry[TAKE\[CurlyPhi]_, TAKEg_, jahr_] := 
        Module[{\ \[CurlyPhi]0 = 47.09, \ g0 = \ 1, 
            intYeahr}, \[IndentingNewLine]dataEntryFixData; \
\[IndentingNewLine] (*\ 
            MP\ berechnen, \(\(Formel\)\(:\)\)*) \[IndentingNewLine]\
\[CurlyPhi] = \[CurlyPhi]0 \((1 - \ Sign[TAKE\[CurlyPhi]])\) \((1 + \ 
                    Sign[TAKE\[CurlyPhi]])\) + 
              TAKE\[CurlyPhi]; \[IndentingNewLine]Print["\<\[CurlyPhi] = \>", \
\[CurlyPhi]]; \[IndentingNewLine]\[CurlyPhi]Vert = \
\(-Sign[\[CurlyPhi]]\)*\((90 - Abs[\[CurlyPhi]])\); \[IndentingNewLine]g = 
            g0 \((1 - \ Sign[TAKEg])\) \((1 + \ Sign[TAKEg])\) + 
              TAKEg; \[IndentingNewLine]Print["\<g = \>", 
            g]; \[IndentingNewLine] (*\ 
            Stunden\  === \(\(>\)\(\ \)\(Rad - 
                  Umrechnungsfaktor\)\)\ *) \[IndentingNewLine]hour = \ 
            2\ Pi/24\ \ ; \ \[IndentingNewLine] (*\ 
            Jahrestage\ rechnen\ *) \[IndentingNewLine]jahresTage[
              intYeahr_] := \ 
            365\ \ Mod[intYeahr, 2000] + 
              Floor[
                Mod[\ Mod[intYeahr, 2000], 2000]/
                  4]; \[IndentingNewLine]jahresTage[
            jahr]; \[IndentingNewLine]jahrOut = 
            jahr; \[IndentingNewLine]Print["\<OUT-Variabeln: \[CurlyPhi], \
\[CurlyPhi]Vert, g, hour, jahresTage, jahrOut\>"];\ ];\)\[IndentingNewLine] \
(*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\)\(=\)*) \[IndentingNewLine] \
(*\ \(\(===\)\(\(>\)\(\ \)\(INPUT\)\)\), \ hMin = \ 1. \ Stunde, \ 
      hMax = Letzte\ Stunde\ \((h)\)\ *) \[IndentingNewLine] (*\ 
      Beispiel : \ Werte\ hMin = \ \(-5\) h, \(-4\) h,  ... , 0  h,  ... , \ 
      hMax = 5  
          h\ *) \[IndentingNewLine] (*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\)\(=\)*) \), "\[IndentingNewLine]", 
    \(\(ombrixGzentr[hMin_, hMax_] := 
        Module[{tVar, \[CurlyPhi]Var}, \[IndentingNewLine]Print["\<Der Modul \
dataEntry wird hier vorausgesetzt!\>"]; \[IndentingNewLine] (*\ 
            Ost - West - \(\(Koordinate\)\(:\)\)*) \[IndentingNewLine]MP[
              tVar_, \[CurlyPhi]Var_] := 
            g\ Tan[tVar\ \ hour]/\ 
                Sin[\((90 - \[CurlyPhi]Var)\)\ Degree]; \[IndentingNewLine] \
(*\ Ursprung\ versetzt, \ 
            Nord - S\[UDoubleDot]d - 
              Koordinate\ *) \[IndentingNewLine]ursprung[\[CurlyPhi]Var_] := \
{\ 0, \(-g\)/Tan[\[CurlyPhi]Var\ Degree]}; \[IndentingNewLine] (*\ 
            Tabelle\ der\ Plotpunkte\ rechnen\ \
*) \[IndentingNewLine]tabPlotPunkte[\[CurlyPhi]Var_] := 
            Table[{MP[tVar, \[CurlyPhi]Var], 
                g/Tan[\((90 - \[CurlyPhi]Var)\)\ Degree]}, {tVar, hMin, hMax, 
                1}]; \ \[IndentingNewLine]Print["\<tabPlotPunkte = \>", 
            tabPlotPunkte[\[CurlyPhi]] // N]; \[IndentingNewLine] (*\ 
            OmbrixPlot\ machen\  === \(\(>\)\(\ \)\(Ombrix - 
                  Zifferblatt\)\)\ *) \[IndentingNewLine]ombixPlot = 
            Show[Graphics[
                Table[Line[{ursprung[\[CurlyPhi]], \
\(tabPlotPunkte[\[CurlyPhi]]\)[\([n]\)]}], {n, 1, 
                    Length[tabPlotPunkte[\[CurlyPhi]]]}]], 
              AspectRatio \[Rule] 
                Automatic]; \ \[IndentingNewLine]Print["\<OUT-Funktionen: MP, \
ursprung, tabPlotPunkte, ombixPlot\>"];];\)\[IndentingNewLine] (*\(\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\)\(=\)*) \[IndentingNewLine] (*\ \
\(\(===\)\(\(>\)\(\ \)\(INPUT\)\)\), \ hMin = \ 1. \ Stunde, \ 
      hMax = Letzte\ Stunde\ \((h)\)\ *) \[IndentingNewLine] (*\ 
      Beispiel : \ Werte\ hMin = \ \(-5\) h, \(-4\) h,  ... , 0  h,  ... , \ 
      hMax = 5  
          h\ *) \[IndentingNewLine] (*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\)\(=\)*) \), "\[IndentingNewLine]", 
    \(\(ombrixGzentrDeltaStd[hMin_, hMax_, deltaStd_] := 
        Module[{tVar, \[CurlyPhi]Var, 
            diff}, \[IndentingNewLine]Print["\<Der Modul dataEntry wird hier \
vorausgesetzt!\>"]; \[IndentingNewLine] (*\ 
            Ost - West - \(\(Koordinate\)\(:\)\)*) \[IndentingNewLine]MP[
              tVar_, \[CurlyPhi]Var_, diff_] := 
            g\ Tan[\((tVar - diff)\)\ hour]/\ 
                Sin[\((90 - \[CurlyPhi]Var)\)\ Degree]; \[IndentingNewLine] \
(*\ Ursprung\ versetzt, \ 
            Nord - S\[UDoubleDot]d - 
              Koordinate\ *) \[IndentingNewLine]ursprung[\[CurlyPhi]Var_] := \
{\ 0, \(-g\)/Tan[\[CurlyPhi]Var\ Degree]}; \[IndentingNewLine] (*\ 
            Tabelle\ der\ Plotpunkte\ rechnen\ \
*) \[IndentingNewLine]tabPlotPunkte[\[CurlyPhi]Var_] := 
            Table[{MP[tVar, \[CurlyPhi]Var, deltaStd], 
                g/Tan[\((90 - \[CurlyPhi]Var)\)\ Degree]}, {tVar, hMin, hMax, 
                1}]; \ \[IndentingNewLine]Print["\<tabPlotPunkte = \>", 
            tabPlotPunkte[\[CurlyPhi]] // N]; \[IndentingNewLine] (*\ 
            OmbrixPlot\ machen\  === \(\(>\)\(\ \)\(Ombrix - 
                  Zifferblatt\)\)\ *) \[IndentingNewLine]ombixPlot = 
            Show[Graphics[
                Table[Line[{ursprung[\[CurlyPhi]], \
\(tabPlotPunkte[\[CurlyPhi]]\)[\([n]\)]}], {n, 1, 
                    Length[tabPlotPunkte[\[CurlyPhi]]]}]], 
              AspectRatio \[Rule] 
                Automatic]; \ \ \[IndentingNewLine]Print["\<OUT-Funktionen: \
MP, ursprung, tabPlotPunkte, ombixPlot\>"];];\)\[IndentingNewLine] \
(*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\)\(=\)*) \[IndentingNewLine] \
(*\ tage\  === \(\(>\)\(\ \)\(Berechnung\ der\ Anzahl\ Tage\ seit\ 31.12 . \ 
              letzten\ Jahres\)\)\ *) \[IndentingNewLine] (*\ 
      fpTage\  === \(\(>\)\(\ \)\(Berechnung\ der\ Anzahl\ Tage\ seit\ \
letztem\ Fr\[UDoubleDot]hlingsbeginn\)\), \ \(\(Jan\)\(.\)\)\  = \ 
        13. \ \(\(Mt\)\(.\)\), \ \(\(Feb\)\(.\)\)\  = \ 
        14. \ \(\(Mt\)\(.\)\)\ *) \[IndentingNewLine] (*\ tageS, \ 
      fpTageS\  === \(\(>\)\(\ \)\(f\[UDoubleDot]r\ Schaltjahre\)\), \ 
      ein\ Tag\ mehr\ \((ein\ Tag\ mehr)\)\ *) \[IndentingNewLine] \
(*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\)\(=\)*) \), "\
\[IndentingNewLine]", 
    \(\(kalender[jour_, mois_] := 
        Module[{m, n}, \ \[IndentingNewLine]m[n_] := 31; m[2] = 28; 
          m[4] = 30; m[6] = 30; \ m[9] = 30; m[11] = 30; m[14] = 28; 
          m[0] = 0; \[IndentingNewLine]tage[day_, mon_] = 
            Sum[m[n], {n, 1, mon}] - m[mon] + day; \[IndentingNewLine]tageSJ[
              day_, mon_] = 
            If[mon < 3, tage[day, mon], 
              tage[day, mon] + 1]; \[IndentingNewLine]fpTage[day_, mon_] = 
            tage[day, mon] - tage[21, 3]; \[IndentingNewLine]fpTageSJ[day_, 
              mon_] = tage[day, mon] - tage[21, 3] + 
              1; \[IndentingNewLine]Print["\<   tage[jour,mois] = \>", \ 
            tage[jour, 
              mois], \[IndentingNewLine]"\<   tageSJ[jour,mois] = \>", 
            tageSJ[jour, 
              mois], \[IndentingNewLine]"\<   fpTage[jour,mois] = \>", 
            fpTage[jour, 
              mois], \[IndentingNewLine]"\<   fpTageSJ[jour,mois] = \>", 
            fpTageSJ[jour, 
              mois]\ ]; \ \ \[IndentingNewLine]Print["\<OUT-Funktionen: tage \
,tageSJ, fpTage, fpTageSJ\>"]; \ 
          Print["\<Funktioniert f\[UDoubleDot]r positiv eingegebene \
Werte\>"];];\)\[IndentingNewLine] (*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\)\(=\)*) \), "\[IndentingNewLine]", 
    \(\(zeitGleichung[plotYes1_, jahr_] := 
        Module[{disp}, \[IndentingNewLine] (*\ \(putz;\)\ \
*) \[IndentingNewLine] (*\ 
            Jahr\ auf\ 2\ Stellen\ angeben . \ Z . B . \ 
                00\ statt\ 2000\ *) \[IndentingNewLine]dataEntry[0, 0, 
            jahr]; \[IndentingNewLine] (*\ 
            Keplerfunktion\ *) \[IndentingNewLine]f[eE_, d_] := \ 
            eE - e\ Sin[eE]\  - m0 - m01\ jahresTage[jahr] - 
              m01\ \ \ d; \[IndentingNewLine]eE[d_] := 
            eNS\  /. FindRoot[
                f[eNS, d] \[Equal] 0, {eNS, 3}]; \[IndentingNewLine]zG[d_] := 
            L0 + m0 + \((L01 + m01)\) d\ \  + \ 
              Mod[\((L01 + m01)\) jahresTage[jahr], \[IndentingNewLine]360] - 
              ArcTan[Tan[
                    2\ ArcTan[
                          Sqrt[\((1 + e)\)/\((1 - e)\)]\ Tan[eE[d]/2\ ]] + 
                      L0 + L01\ d + \ L01\ jahresTage[jahr]]\ \ Cos[Eps]] - \ 
              jahrOut\ 2\ Pi; \[IndentingNewLine] (*\ 
            Die\ Spr\[UDoubleDot]nge\ des\ Arcustangens\ durch\ Stetigmachen\ \
resp . \ Zusammensetzen\ \(\(\[UDoubleDot]berwinden\)\(:\)\)\
*) \[IndentingNewLine]updown[
              d_] := \((1 - Sign[\((zG[d] - 1)\)])\)/2\ \ zG[
                d]; \[IndentingNewLine]upup[
              d_] := \((1 + Sign[\((zG[d] - 1)\)])\)/
                2\ \((zG[d] - Pi)\); \[IndentingNewLine]up[d_] := 
            updown[d] + upup[d]; \[IndentingNewLine]downall[
              d_] := \((1 - Sign[\((zG[d] + 1)\)])\)\ /
                2\ \ \((zG[d] + Pi)\); \[IndentingNewLine]upall[
              d_] := \((1 + Sign[\((zG[d] + 1)\)])\)/2\ up[
                d]; \[IndentingNewLine]glattZG[
              d_] := \((upall[d] + downall[d])\); \[IndentingNewLine]zgStd[
              d_] := glattZG[
                  d]/\((2  Pi)\)\ 24\ ; \[IndentingNewLine]zgMinuten[d_] := 
            glattZG[d]/\((2  Pi)\)\ 24\ 60; \[IndentingNewLine]If[
            plotYes1 == 1, Goto[erstens], 
            Goto[zweitens]]; \[IndentingNewLine]Label[erstens]; 
          Plot[zgMinuten[day]\ , {day, \(-191\), 356}]; 
          Goto[drittens]; \[IndentingNewLine]Label[zweitens]; 
          Print["\<Kein Plot, nur Initialisierung\>"]; \
\[IndentingNewLine]Label[
            drittens]; \ \ \[IndentingNewLine]Print["\<OUT-Funktionen: f, eE, \
zG, updown, upup, up, downall, upall, glattZG, zgStd, zgMinuten\>"]; \ 
          Print["\<Jahr auf 2 Stellen angeben. Z.B. 00 statt 2000\>"];];\)\
\[IndentingNewLine] (*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\)\(=\)*) \
\), "\[IndentingNewLine]", 
    \(\(deklin[myTag_, myMonat_] := 
        Module[{dayNow}, \[IndentingNewLine]dayNow = 
            tage[myTag, myMonat]; \[IndentingNewLine]deltaAngle[dd_] := 
            360/\((2\ Pi)\)\ ArcSin[
                Sin[2\ ArcTan[
                          Sqrt[\((1 + e)\)/\((1 - e)\)]\ Tan[
                              Evaluate[eE[dd]]/2\ ]] + L0 + L01\ dd]\ \ Sin[
                    Eps]]; \[IndentingNewLine]Print["\<OUT-Funktionen: \
deltaAngle = \>", 
            deltaAngle[
              tage[myTag, myMonat]]\ ]; \[IndentingNewLine]deltaAngle[
            dayNow]\ ];\)\[IndentingNewLine] (*\(\(===\)\(===\)\(===\)\(===\)\
\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\
\(===\)\(===\)\)\(=\)*) \), "\[IndentingNewLine]", 
    \(\(dekPlot[dataListe_, horVert_, tMin_, tMax_, yRangeMin_, yRangeMax_, 
          plotYes1_] := 
        Module[{fi}, \[IndentingNewLine]\ \ If[horVert \[Equal] 1, 
            fi = \[CurlyPhi], \ 
            If[horVert \[Equal] 0, fi = \[CurlyPhi]Vert, 
              Print["\<Vertikal: horVert=0 und horizontal horVert = 1 \
!!!!\>"]]]; \[IndentingNewLine] (*\ 
            Definitionen\ und\ Rechnungen\ *) \[IndentingNewLine]v[d_, fi_, 
              t_] := g/\((Cos[Sign[\[CurlyPhi]]\ \ d\ Degree]\ Cos[
                        t\ hour]\ Sin[fi\ Degree]\  + \ 
                    Sin[Sign[\[CurlyPhi]]\ d\ Degree]\ Cos[
                        fi\ Degree])\)\ {\((Cos[
                      Sign[\[CurlyPhi]]\ d\ Degree]\ Sin[t\ hour])\), 
                Sign[\[CurlyPhi]] \((\((Cos[
                            Sign[\[CurlyPhi]]\ d\ Degree]\ Cos[t\ hour]\ Cos[
                            fi\ Degree]\  - \ 
                        Sin[Sign[\[CurlyPhi]]\ d\ Degree]\ Sin[
                            fi\ Degree])\)\ )\)}; \[IndentingNewLine]If[
            plotYes1 == 1, Goto[erstens], 
            Goto[zweitens]]; \[IndentingNewLine]Label[erstens]; 
          ParametricPlot[
            Evaluate[
              Table[v[dataListe[\([j]\)], fi, t], {j, 1, 
                  Length[dataListe]}]], {t, tMin, tMax}, \ 
            AspectRatio \[Rule] Automatic, 
            PlotRange \[Rule] {yRangeMin, yRangeMax}]; 
          Print["\<Goto ist verwendet worden\>"]; 
          Goto[drittens]; \[IndentingNewLine]Label[zweitens]; 
          Print["\<Kein Plot, nur Initialisierung von v[d,fi,t]!\>"]; 
          Print["\<Goto ist verwendet worden\>"]; \[IndentingNewLine]Label[
            drittens]; \[IndentingNewLine]Print["\<OUT-Funktionen: v\>"];\ ];\
\)\[IndentingNewLine] (*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\)\(=\)*) \
\), "\[IndentingNewLine]", 
    \(\(zeitSchlaufen[dataListe_, horVert_, 
          maxDekNummer_, {paramMin_, paramMax_}, {rangeMin_, 
            rangeMax_}, {minNumber_, maxNumber_}] := 
        Module[{fi}, \[IndentingNewLine]\ \ If[horVert \[Equal] 1, 
            fi = \[CurlyPhi], \ 
            If[horVert \[Equal] 0, fi = \[CurlyPhi]Vert, 
              Print["\<Vertikal: horVert=0 und horizontal horVert = 1 \
!!!!\>"]; Goto[endeProgramm]]]; \[IndentingNewLine]parPlot = 
            ParametricPlot[
              Evaluate[
                Table[v[dataListe[\([k]\)], fi, t], {k, 1, 
                    Length[dataListe]}]], {t, paramMin, paramMax}, \ 
              AspectRatio \[Rule] Automatic, 
              PlotRange \[Rule] {rangeMin, 
                  rangeMax}, \[IndentingNewLine]Epilog -> {Table[
                    Line[{\ v[dataListe[\([maxDekNummer]\)], fi, k], 
                        ursprung[fi]}], {k, minNumber, maxNumber, 1}]}, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]tabd[n_] := 
            Table[v[ArcSin[
                    Sin[2\ ArcTan[
                              Sqrt[\((1 + e)\)/\((1 - e)\)]\ Tan[
                                  eE[d]/2\ ]] + L0 + L01\ d]\ Sin[Eps]]\ /
                  Degree, fi, \((n - zgStd[d])\)], {d, \(-100\), 
                300}]; \[IndentingNewLine]listp[n_] := 
            ListPlot[tabd[n], PlotJoined \[Rule] True, \ 
              AspectRatio \[Rule] Automatic, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]listp0 = 
            Show[Table[listp[j], {j, minNumber, maxNumber, 1}], 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]Show[
            parPlot, listp0, 
            DisplayFunction \[Rule] $DisplayFunction]; \
\[IndentingNewLine]Label[
            endeProgramm]; \[IndentingNewLine]Print["\<Ende\>"]; \
\[IndentingNewLine]Print["\<OUT-Funktionen und Variablen: parPlot, tabd, \
listp, listp0\>"];];\)\[IndentingNewLine] (*\ 
      Alternativdefinition\ ohne\ Klammern\ *) \), "\[IndentingNewLine]", 
    \(\(zeitSchlaufen[dataListe_, horVert_, maxDekNummer_, paramMin_, 
          paramMax_, rangeMin_, rangeMax_, minNumber_, maxNumber_] := 
        zeitSchlaufen[dataListe, horVert, 
          maxDekNummer, {paramMin, paramMax}, {rangeMin, 
            rangeMax}, {minNumber, 
            maxNumber}];\)\[IndentingNewLine] \
(*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\)\(=\)*) \), "\
\[IndentingNewLine]", 
    \(\(newPositionWithPrint[ostNord_, zenitNord_, \[CurlyPhi]_] := 
        Module[{a, b, \[CurlyPhi]Old, u, v, w, d, r, r1, R, dY, dZ, xKS, yKS, 
            zKS, goAeq, xNew, yNew, zNew, solvU, solvV, uRichtung, vRichtung, 
            u1, u2, u3, v1, v2, v3, vv}, \[IndentingNewLine] (*\ 
            Umrechnung\ mit\ Vektorprodukt\ *) \[IndentingNewLine] (*\ \
\(\(===\)\(\(>\)\(\ \)\(INPUT\)\)\), \ 
            Altgrad\ *) \ \ \ \ \ \[IndentingNewLine]a = \ ostNord\ ; \ 
          b = zenitNord\ ; \ \[CurlyPhi]Old = \[CurlyPhi]; \
\[IndentingNewLine]u = {Cos[a\ Degree], Sin[a\ Degree], 0}; 
          Print["\<u = \>", \ 
            u // N]; \[IndentingNewLine]v = {\(-Sin[a\ Degree]\) 
                Sin[b\ Degree], Cos[a\ Degree] Sin[b\ Degree], 
              Cos[b\ Degree]}; 
          Print["\<v = \>", v // N]; \[IndentingNewLine] (*\ 
            w : \ Normalenvektor\ im\ Ortshorizontsystem\ \
*) \[IndentingNewLine]w = Transpose[{Cross[u, v]}]; 
          Print["\<w = \>", \(w // N\) // 
              MatrixForm]; \[IndentingNewLine] (*\ 
            Drehung\ um\ Ost - West - 
              Achse\ im\ Ortshorizontsystem\ *) \[IndentingNewLine] (*\ 
            Drehung\ ins\ Orst\[ADoubleDot]quatorsystem\ \
*) \[IndentingNewLine]\[CurlyPhi]Old = \[CurlyPhi]; 
          d = \((90 - \[CurlyPhi]Old)\)\ ; 
          Print["\<d = \>", 
            d // N]; \[IndentingNewLine]dreh = {{1, 0, 0}, {0, 
                Cos[d\ Degree], \(-Sin[d\ Degree]\)}, {0, Sin[d\ Degree], 
                Cos[d\ Degree]}}; 
          Print["\<dreh = \>"\ , \ \(dreh // N\) // 
              MatrixForm]; \[IndentingNewLine]r = dreh . w; 
          Print["\<r = \>", \ \(r // N\) // MatrixForm]; \ r1 = Flatten[r]; 
          Print["\<r1 = \>", 
            r1 // N]; \[IndentingNewLine]R = {\(-\ 
                r1[\([2]\)]\), \(-r1[\([1]\)]\), r1[\([3]\)]}; 
          Print["\<R = \>", R // N]; \[IndentingNewLine]Delta1 = 
            Sign[r1[\([3]\)]]\ ArcCos[
                Sqrt[\((R[\([1]\)]^2 + R[\([2]\)]^2)\)/\((R[\([1]\)]^2 + 
                        R[\([2]\)]^2 + 
                        R[\([3]\)]^2)\)]]\ ; \[IndentingNewLine] (*\ 
            Delta1\ ist\ Winkel\ zwischen\ Vektor\ und\ \
Orts\[ADoubleDot]quatorebene, \ 
            d . h . \ 
                die\ neue\ geographische\ Breite\ \
*) \[IndentingNewLine]Delta2 = \ 
            Sign[r1[\([3]\)]]\ ArcCos[
                Sqrt[R[\([1]\)]^2/\((R[\([1]\)]^2 + 
                        R[\([2]\)]^2)\)]]; \[IndentingNewLine] (*\ 
            Delta2\ ist\ Winkel\ zwischen\ Vektorprojektion\ in\ Orts\
\[ADoubleDot]quatorebene\ x\ resp . \ 
                S\[UDoubleDot]d\ *) \[IndentingNewLine]dY = Delta1; 
          dZ = Delta2; \[IndentingNewLine]Delta1Grad = Delta1/Degree // N; \ 
          Delta2Grad = Delta2/\((2\ Pi)\)\ 360 // N;; \ 
          Delta2Std = 
            Delta2/\((2\ Pi)\)\ 24 // 
              N; \[IndentingNewLine]Print["\<Delta1Grad = \>", 
            Delta1Grad, "\< Vorzeichen= \>"\ , \ Sign[r1[\([3]\)]]]; \n
          Print["\<Delta2Grad = \>", Delta2Grad, "\<, Delta2Std = \>", 
            Delta2Std, "\< Vorzeichen= \>"\ , \ 
            Sign[r1[\([2]\)]]]; \[IndentingNewLine] (*Umrechnen\ des\ \
Vertikalvektors\ der\ Wand\ zur\ Drehung\ des\ Outputs\ in\ Vertikallage, \ 
            in\ Einzelschritten*) \[IndentingNewLine]Print["\<Test \
Matrixprodukt ===> \>", 
            dreh . v \[Equal] 
              Flatten[dreh . Transpose[{v}]]]; \[IndentingNewLine]xKS = {1, 
              0, 0}; yKS = {0, 1, 0}; 
          zKS = {0, 0, 
              1}; \[IndentingNewLine]Print["\<Koordinatensystem : \>", {xKS, 
                  yKS, zKS} // MatrixForm\ \ ]\[IndentingNewLine]\(goAeq[
                vec_] := {\(-\((dreh . vec)\)[\([2]\)]\), \(-\((dreh . 
                        vec)\)[\([1]\)]\), \((dreh . 
                      vec)\)[\([3]\)]}\); \
\[IndentingNewLine]Print["\<Prozedur Koord.Umrechnung von - \
r1[[2]],-r1[[1]],r1[[3]] auf dreh.vec anwenden\>"]; \[IndentingNewLine]vAeq = 
            goAeq[v]; uAeq = goAeq[u]; xAeq = goAeq[xKS]; yAeq = goAeq[yKS]; 
          zAeq = goAeq[zKS]; \[IndentingNewLine]Print["\<===>vAeq = \>", 
            vAeq // N]; \[IndentingNewLine]Print["\<===>uAeq = \>", 
            uAeq // N]; \[IndentingNewLine]Print["\<===>xAeq = \>", 
            xAeq // N]; \[IndentingNewLine]Print["\<===>yAeq = \>", 
            yAeq // N]; \[IndentingNewLine]Print["\<===>zAeq = \>", 
            zAeq // N]; \[IndentingNewLine]drehZ = {{Cos[dZ], \(-Sin[dZ]\), 
                0}, {Sin[dZ], Cos[dZ], 0}, {0, 0, 
                1}}; \[IndentingNewLine]Print["\<drehZ =\>", \ \(drehZ // 
                N\) // MatrixForm]; \[IndentingNewLine]drehY = {{Cos[dY], 
                0, \(-Sin[dY]\)}, {0, 1, 0}, {Sin[dY], 0, 
                Cos[dY]}}; \[IndentingNewLine]Print["\<drehY =\>", \ \(drehY // 
                N\) // MatrixForm]; \[IndentingNewLine]goNew[vec_] := 
            drehZ . \((drehY . 
                  vec)\); \[IndentingNewLine]Print["\<Vektor um \
Breitendifferenz und dann um L\[ADoubleDot]ngendifferenz drehen\>"]; \
\[IndentingNewLine]xNew = goNew[xKS]; yNew = goNew[yKS]; 
          zNew = goNew[zKS]; \[IndentingNewLine]Print["\<xNew KS =\>", \ 
            xNew // N]; \[IndentingNewLine]Print["\<yNew KS =\>", \ 
            yNew // N]; \[IndentingNewLine]Print["\<zNew KS =\>", \ 
            zNew // N]; \[IndentingNewLine]solvU = \(\(Solve[
                    uAeq \[Equal] 
                      u1\ xNew\  + \ u2\ yNew\  + \ u3\ zNew, {u1, u2, u3}] // 
                  Chop\) // Flatten\) // N; 
          uRichtung = {u1, u2, u3} /. 
              solvU; \[IndentingNewLine]Print["\<Kontrolle: gedrehtes u im \
neuen Parallelebenen-KS dargestellt ===> \>", \ 
            uRichtung, "\< 1. Koord. muss 0 sein\>"]; \[IndentingNewLine] (*\ 
            vAeq\ hat\ schon\ ins\ Orts\[ADoubleDot]quatorsyst . \ 
                umgerechnete\ \(\(Koord\)\(.\)\)*) \[IndentingNewLine]solvV = \
\(\(Solve[vAeq \[Equal] v1\ xNew\  + \ v2\ yNew\  + \ v3\ zNew, {v1, v2, 
                      v3}] // Chop\) // Flatten\) // 
              N; \[IndentingNewLine]vRichtung = {v1, v2, v3} /. 
              solvV; \[IndentingNewLine]Print["\<Kontrolle: gedrehtes v im \
neuen Parallelebenen-KS dargestellt ===> \>", \ 
            vRichtung, "\< 1. Koord. muss 0 sein\>"]; \[IndentingNewLine]vLen[
              vec_] := 
            Sqrt[vec . 
                vec]; \  (*\ \(===\)\(\(>\)\(\ \
\)\(Vektorl\[ADoubleDot]nge\)\)\ *) \[IndentingNewLine]\  (*\ \
\(===\)\(\(>\)\(\ \)\(Vektorl\[ADoubleDot]nge\)\)\ *) \[IndentingNewLine]\  \
(*\ \(===\)\(\(>\)\(\ \)\(Drehung\ der\ Vertikalen\)\)\ \
*) \[IndentingNewLine]drehNewArc = \(-Sign[vRichtung[\([2]\)]]\)\ ArcCos[
                vRichtung . zKS/\((vLen[vRichtung]\ vLen[zKS])\)]; 
          drehNewGrad = drehNewArc\ /\((2  Pi)\)\ 360; \[IndentingNewLine]\ 
          vv = drehNewArc; \[IndentingNewLine]Print["\<drehNewGrad, \>", 
            drehNewGrad]; \[IndentingNewLine]Print["\<vRichtung \>", 
            vRichtung]; \[IndentingNewLine]Print["\<zKS \>", 
            zKS]; \[IndentingNewLine]drehPlot = {{Cos[
                  vv], \(-Sin[vv]\)}, {Sin[vv], 
                Cos[vv]}}; \ \[IndentingNewLine]Print["\<drehPlot = \>", \ 
            drehPlot // 
              MatrixForm]; \[IndentingNewLine]Print["\<Out-Variablen: Delta1, \
Delta1Grad, Delta2, Delta2Std, drehNewArc,drehNewGrad, drehPlot, \
vLen\>"];];\)\[IndentingNewLine] (*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\)\(=\)*) \), "\[IndentingNewLine]", 
    \(\(newPosition[ostNord_, zenitNord_, \[CurlyPhi]_] := 
        Module[{a, b, \[CurlyPhi]Old, u, v, w, d, r, r1, R, dY, dZ, xKS, yKS, 
            zKS, goAeq, xNew, yNew, zNew, solvU, solvV, uRichtung, vRichtung, 
            u1, u2, u3, v1, v2, v3, vv}, \[IndentingNewLine] (*\ 
            Umrechnung\ mit\ Vektorprodukt\ *) \[IndentingNewLine] (*\ \
\(\(===\)\(\(>\)\(\ \)\(INPUT\)\)\), \ 
            Altgrad\ *) \ \ \ \ \ \[IndentingNewLine]a = \ ostNord\ ; \ 
          b = zenitNord\ ; \ \[CurlyPhi]Old = \[CurlyPhi]; \
\[IndentingNewLine]u = {Cos[a\ Degree], Sin[a\ Degree], 0}; 
          v = {\(-Sin[a\ Degree]\) Sin[b\ Degree], 
              Cos[a\ Degree] Sin[b\ Degree], 
              Cos[b\ Degree]}; \[IndentingNewLine] (*\ 
            w : \ Normalenvektor\ im\ Ortshorizontsystem\ \
*) \[IndentingNewLine]w = Transpose[{Cross[u, v]}]; \[IndentingNewLine] (*\ 
            Drehung\ um\ Ost - West - 
              Achse\ im\ Ortshorizontsystem\ *) \[IndentingNewLine] (*\ 
            
            Drehung\ ins\ Orst\[ADoubleDot]quatorsystem\ \
*) \[IndentingNewLine]d = \((90 - \[CurlyPhi]Old)\)\ ; \
\[IndentingNewLine]dreh = {{1, 0, 0}, {0, 
                Cos[d\ Degree], \(-Sin[d\ Degree]\)}, {0, Sin[d\ Degree], 
                Cos[d\ Degree]}}; \[IndentingNewLine]r = dreh . w; \ 
          r1 = Flatten[r]; \[IndentingNewLine] (*\ alte\  - y\ heisst\ x, \ 
            alte\  - 
              x\ heisst\ y\ *) \[IndentingNewLine]R = {\(-\ 
                r1[\([2]\)]\), \(-r1[\([1]\)]\), 
              r1[\([3]\)]}; \[IndentingNewLine]Delta1 = 
            Sign[r1[\([3]\)]]\ \ ArcCos[
                Sqrt[\((R[\([1]\)]^2 + R[\([2]\)]^2)\)/\((R[\([1]\)]^2 + 
                        R[\([2]\)]^2 + 
                        R[\([3]\)]^2)\)]]\ ; \[IndentingNewLine] (*\ 
            Delta1\ ist\ Winkel\ zwischen\ Vektor\ und\ \
Orts\[ADoubleDot]quatorebene, \ 
            d . h . \ 
                die\ neue\ geographische\ Breite\ \
*) \[IndentingNewLine]Delta2 = \ 
            Sign[r1[\([3]\)]]\ ArcCos[
                Sqrt[R[\([1]\)]^2/\((R[\([1]\)]^2 + 
                        R[\([2]\)]^2)\)]]; \[IndentingNewLine] (*\ 
            Delta2\ ist\ Winkel\ zwischen\ Vektorprojektion\ in\ Orts\
\[ADoubleDot]quatorebene\ x\ resp . \ 
                S\[UDoubleDot]d\ *) \[IndentingNewLine]dY = Delta1; 
          dZ = Delta2; \[IndentingNewLine]Delta1Grad = Delta1/Degree // N; \ 
          Delta2Grad = Delta2/\((2\ Pi)\)\ 360 // N;; \ 
          Delta2Std = 
            Delta2/\((2\ Pi)\)\ 24 // 
              N; \[IndentingNewLine]Print["\<Delta1Grad = \>", 
            Delta1Grad, "\< Vorzeichen= \>"\ , \ 
            Sign[r1[\([3]\)]]]; \n\ \ \ \ \ Print["\<Delta2Grad = \>", 
            Delta2Grad, "\<, Delta2Std = \>", 
            Delta2Std, "\< Vorzeichen= \>"\ , \ 
            Sign[r1[\([2]\)]]]; \[IndentingNewLine] (*Umrechnen\ des\ \
Vertikalvektors\ der\ Wand\ zur\ Drehung\ des\ Outputs\ in\ Vertikallage, \ 
            in\ Einzelschritten*) \[IndentingNewLine]xKS = {1, 0, 0}; 
          yKS = {0, 1, 0}; 
          zKS = {0, 0, 1}; \[IndentingNewLine]goAeq[
              vec_] := {\(-\((dreh . vec)\)[\([2]\)]\), \(-\((dreh . 
                      vec)\)[\([1]\)]\), \((dreh . 
                    vec)\)[\([3]\)]}; \[IndentingNewLine]vAeq = goAeq[v]; 
          uAeq = goAeq[u]; xAeq = goAeq[xKS]; yAeq = goAeq[yKS]; 
          zAeq = goAeq[
              zKS]; \[IndentingNewLine]drehZ = {{Cos[dZ], \(-Sin[dZ]\), 
                0}, {Sin[dZ], Cos[dZ], 0}, {0, 0, 
                1}}; \[IndentingNewLine]drehY = {{Cos[dY], 
                0, \(-Sin[dY]\)}, {0, 1, 0}, {Sin[dY], 0, 
                Cos[dY]}}; \[IndentingNewLine]goNew[vec_] := 
            drehZ . \((drehY . vec)\); \[IndentingNewLine]xNew = goNew[xKS]; 
          yNew = goNew[yKS]; 
          zNew = goNew[
              zKS]; \[IndentingNewLine]solvU = \(\(Solve[
                    uAeq \[Equal] 
                      u1\ xNew\  + \ u2\ yNew\  + \ u3\ zNew, {u1, u2, u3}] // 
                  Chop\) // Flatten\) // 
              N; \[IndentingNewLine]solvV = \(\(Solve[
                    vAeq \[Equal] 
                      v1\ xNew\  + \ v2\ yNew\  + \ v3\ zNew, {v1, v2, v3}] // 
                  Chop\) // Flatten\) // 
              N; \[IndentingNewLine]uRichtung = {u1, u2, u3} /. 
              solvU; \[IndentingNewLine]vRichtung = {v1, v2, v3} /. 
              solvV; \[IndentingNewLine]vLen[vec_] := 
            Sqrt[vec . 
                vec]; \[IndentingNewLine]drehNewArc = \(-Sign[
                  vRichtung[\([2]\)]]\)\ ArcCos[
                vRichtung . zKS/\((vLen[vRichtung]\ vLen[zKS])\)]; 
          drehNewGrad = 
            drehNewArc\ /\((2  Pi)\)\ 360; \ \[IndentingNewLine]vv = 
            drehNewArc; \[IndentingNewLine]Print["\<drehNewGrad = \>", 
            drehNewGrad]; \[IndentingNewLine]drehPlot = {{Cos[
                  vv], \(-Sin[vv]\)}, {Sin[vv], 
                Cos[vv]}}; \ \[IndentingNewLine]Print["\<drehPlot = \>", \ 
            drehPlot // 
              MatrixForm]; \[IndentingNewLine]Print["\<Out-Variablen: Delta1, \
Delta1Grad, Delta2, Delta2Std, drehNewArc,drehNewGrad, drehPlot, \
vLen\>"];];\)\[IndentingNewLine] (*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(\
===\)\)\(=\)*) \), "\[IndentingNewLine]", 
    \(\(drehOmbrixDekSlPlot[{hMin_, hMax_}, {t1_, t2_}, {t3_, t4_}, {k1_, 
            k2_}, {k3_, k4_}, {pr1_, pr2_}, {faktor1_, faktor2_}, {nMitte_, 
            nZiel_}, {nn1_, nn2_}] := 
        Module[{\[CurlyPhi]New, parPlotNow, k5, k6, 
            tabd}, \[IndentingNewLine]\[CurlyPhi]New = \ Delta1Grad; \ 
          fiNew = \ \((90 - Abs[\[CurlyPhi]New])\); \[IndentingNewLine]k5 = 
            Sign[k3]^2\ k3\  + \ \((1 - Sign[k3]^2)\) 
                hMin; \[IndentingNewLine]k6 = 
            Sign[k4]^2\ k4\  + \ \((1 - Sign[k4]^2)\) 
                hMax; \[IndentingNewLine]v[gNow_, \[CurlyPhi]Now_, dNow_, 
              fiNow_, tNow_] := 
            gNow/\((Cos[Sign[\[CurlyPhi]Now]\ \ dNow\ Degree]\ Cos[
                        tNow\ hour]\ Sin[fiNow\ Degree]\  + \ 
                    Sin[Sign[\[CurlyPhi]Now]\ dNow\ Degree]\ Cos[
                        fiNow\ Degree])\)\ {\((Cos[
                      Sign[\[CurlyPhi]Now]\ dNow\ Degree]\ Sin[
                      tNow\ hour])\), 
                Sign[\[CurlyPhi]Now] \((\((Cos[
                            Sign[\[CurlyPhi]Now]\ dNow\ Degree]\ Cos[
                            tNow\ hour]\ Cos[fiNow\ Degree]\  - \ 
                        Sin[Sign[\[CurlyPhi]Now]\ dNow\ Degree]\ Sin[
                            fiNow\ Degree])\)\ )\)}; \[IndentingNewLine]vDreh[
              gNow_, \[CurlyPhi]Now_, dNow_, fiNow_, tNow_] := 
            drehPlot . 
              v[gNow, \[CurlyPhi]Now, dNow, fiNow, 
                tNow]; \[IndentingNewLine] (*\(\(===\)\(\(>\)\(\ \)\(hMin\)\)\
\), hMax\ \
\(eingeben!\)*) \[IndentingNewLine]tabPlotPunkteDelta[\[CurlyPhi]Var_, 
              hMinInt_, hMaxInt_] := 
            Table[{MP[tVar - Delta2Std, \[CurlyPhi]Var], 
                g/Tan[\((90 - \[CurlyPhi]Var)\)\ Degree]}, {tVar, hMinInt, 
                hMaxInt, 1}]; \[IndentingNewLine] (*\ Drehombrix, \ 
            Deklinationslinien*) \[IndentingNewLine]ParametricPlot[
            Evaluate[
              Table[vDreh[g, \[CurlyPhi]New, d[k], fiNew, t], {k, k1, 
                  k2}]], {t, t1, t2}, \ AspectRatio \[Rule] Automatic, 
            PlotRange \[Rule] {pr1, pr2}\ , \[IndentingNewLine]Epilog \[Rule] 
              Join[Table[
                  Line[{drehPlot . ursprung[\[CurlyPhi]New], 
                      drehPlot . \((faktor1 \((\ \(tabPlotPunkteDelta[\
\[CurlyPhi]New, hMin, hMax]\)[\([n]\)] - ursprung[\[CurlyPhi]New])\) + 
                            ursprung[\[CurlyPhi]New])\)}], {n, 1, 
                    Length[tabPlotPunkteDelta[\[CurlyPhi]New, hMin, 
                        hMax]]}], {Line[{drehPlot . ursprung[\[CurlyPhi]New], 
                      faktor2\ drehPlot . \
\(tabPlotPunkte[\[CurlyPhi]New]\)[\([nMitte]\)]}]}]]; \[IndentingNewLine]nn1 \
= Sign[nn1]^2\ nn1\  + \ \((1 - Sign[nn1]^2)\) hMin; \[IndentingNewLine]nn2 = 
            Sign[nn2]^2\ nn2\  + \ \((1 - Sign[nn2]^2)\) 
                hMax; \[IndentingNewLine]parPlotNow = 
            ParametricPlot[
              Evaluate[
                Table[vDreh[g, \[CurlyPhi]New, d[k], 
                    fiNew, \((t - Delta2Std)\)], {k, k1, k2}]], {t, 
                t3 + Delta2Std, t4 + Delta2Std}, \ 
              AspectRatio \[Rule] Automatic, 
              PlotRange \[Rule] {pr1, 
                  pr2}, \[IndentingNewLine]Epilog -> {Join[
                    Table[Line[{vDreh[g, \[CurlyPhi]New, d[nZiel], fiNew, 
                            k - Delta2Std], 
                          drehPlot . ursprung[\[CurlyPhi]New]}], {k, k5, k6, 
                        1}], \ {Line[{drehPlot . ursprung[\[CurlyPhi]New], 
                          faktor2\ drehPlot . \(tabPlotPunkte[\[CurlyPhi]New]\
\)[\([nMitte]\)]}]}\ \ ]}, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]tabd[n_] := 
            Table[vDreh[g, \[CurlyPhi]New, 
                ArcSin[Sin[
                        2\ ArcTan[
                              Sqrt[\((1 + e)\)/\((1 - e)\)]\ Tan[
                                  eE[dd]/2\ ]] + L0 + L01\ dd + \ 
                          L01\ jahresTage[jahrOut]]\ Sin[Eps]]\ /Degree, 
                fiNew, \((n - zgStd[dd] - Delta2Std)\)], {dd, \(-100\), 
                300}]; \[IndentingNewLine]listp[n_] := 
            ListPlot[tabd[n], PlotJoined \[Rule] True, \ 
              AspectRatio \[Rule] Automatic, 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]listp0 = 
            Show[Table[listp[nn], {nn, nn1, nn2}], 
              DisplayFunction \[Rule] Identity]; \[IndentingNewLine]\(Show[
              parPlotNow, listp0, 
              DisplayFunction \[Rule] $DisplayFunction];\)];\)\), "\
\[IndentingNewLine]", 
    \(\(\(drehOmbrixDekSlPlot[hMin_, hMax_, t1_, t2_, t3_, t4_, k1_, k2_, 
        k3_, k4_, pr1_, pr2_, faktor1_, faktor2_, nMitte_, nZiel_, nn1, 
        nn2]\)\(:=\)\(drehOmbrixDekSlPlot[{hMin, hMax}, {t1, t2}, {t3, 
          t4}, {k1, k2}, {k3, k4}, {pr1, pr2}, {faktor1, faktor2}, {nMitte, 
          nZiel}, {nn1, 
          nn2}, \[IndentingNewLine]\(Print["\<Ende\>"];\)]\)\(\
\[IndentingNewLine]\)\( (*\(\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\
\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\(===\)\)\(=\)*) \
\)\)\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Initialisation der aktivierten Module durch Aufruf unter Beachtung \
Aufrufhierarchie:\
\>", "Section"],

Cell[CellGroupData[{

Cell["\<\
Die Sache FUNKTIONIERT NUR, wenn die Hierarchie eingehalten wird. Gewisse \
Ausgelassene Module verursachen sonst Fehler, weil sie in andern Modulen \
benutzt werden!!!\
\>", "Subsection"],

Cell[CellGroupData[{

Cell["Beispiele (* INITIALISATIONEN *)", "Subsubsection"],

Cell[BoxData[
    \(m0\)], "Input"],

Cell[BoxData[
    \(dataEntry[30, 50, 12]\)], "Input"],

Cell[BoxData[
    \(dataEntry[0, 0, 0]\)], "Input"],

Cell[BoxData[
    \(dataEntry[0, 0, 0]; \[CurlyPhi]Vert\)], "Input"],

Cell[BoxData[
    \({g, \[CurlyPhi]}\)], "Input"],

Cell[BoxData[
    \(\[CurlyPhi]Vert\)], "Input"],

Cell[BoxData[
    \({jahresTage[12], jahresTage[2012]}\)], "Input"],

Cell[BoxData[
    \(dataEntry[30, 50, 01]; jahrOut\)], "Input"],

Cell[BoxData[
    \(dataEntry[0, 0]; ombrixGzentr[\(-4\), 4]\)], "Input"],

Cell[BoxData[
    \(dataEntry[0, 0]; ombrixGzentr[\(-1\), 5]\)], "Input"],

Cell[BoxData[
    \(ombrixGzentrDeltaStd[\(-3\), 4, 2]\)], "Input"],

Cell[BoxData[
    \(dataEntry[\[CurlyPhi] - 90, 1]; ombrixGzentr[\(-5\), 5]\)], "Input"],

Cell[BoxData[
    \(ombrixGzentrDeltaStd[\(-3\), 4, 2]\)], "Input"],

Cell[BoxData[
    \(kalender[21, 3]\)], "Input"],

Cell[BoxData[
    \(\(\(\ \)\({tage[21, 3]\ , tage[6, 5]}\)\)\)], "Input"],

Cell[BoxData[
    \({{"\<Test\>", "\<21.3.\>", 
        kalender[21, 3]}, \[IndentingNewLine]{"\<Test\>", "\<29.8.\>", 
        kalender[29, 8]}, \[IndentingNewLine]{"\<Test\>", "\<21.12.\>", 
        kalender[21, 12]}, {"\<Test\>", "\<31.12.\>", 
        kalender[20, 15]}, \[IndentingNewLine]{"\<Test\>", "\<21.3.\>", 
        tage[21, 3]}, \[IndentingNewLine]{"\<Test\>", "\<29.8.\>", 
        tage[29, 8]}, \[IndentingNewLine]{"\<Test\>", "\<21.12.\>", 
        tage[21, 12]}, \[IndentingNewLine]{"\<Test\>", "\<31.12.\>", 
        tage[31, 12]}}\)], "Input"],

Cell[BoxData[
    \(\(?eE\)\)], "Input"],

Cell[BoxData[
    \(zeitGleichung[2, 01]\)], "Input"],

Cell[BoxData[
    \(zeitGleichung[1, \ 01]\)], "Input"],

Cell[BoxData[
    \(zeitGleichung[2, \ 01]; zgStd[5]\)], "Input"],

Cell[BoxData[
    \(\(\( (*\ Initialisierung\ *) \)\(\[IndentingNewLine]\)\(dataEntry[0, 
      0]; zeitGleichung[0, 01]; kalender[29, 8]; tage[29, 8];\)\)\)], "Input"],

Cell[BoxData[
    \(deklin[0, 0]\)], "Input"],

Cell[BoxData[
    \(deltaAngle[0]\)], "Input"],

Cell[BoxData[
    \(\(\( (*\ Kontrollen\ *) \)\(\ \ \ \ \)\(?eE\)\)\)], "Input"],

Cell[BoxData[
    \(e\)], "Input"],

Cell[BoxData[
    \(\(?deltaAngle\)\)], "Input"],

Cell[BoxData[
    \(\(\(deltaAngle[0]\)\(;\)\(Plot[
      deltaAngle[d]/\((2  Pi)\) 360, {d, 0, 366}]\)\(;\)\(\ \)\)\)], "Input"],

Cell[BoxData[
    \(\(\( (*\ 
      Test\ *) \)\(\ \ \ \ \)\({deklin[28, 8], deklin[21, 12], 
        deklin[17.805, 3], deklin[21, 3]} // N\)\)\)], "Input"],

Cell[BoxData[
    \(tage[21, 3]\)], "Input"],

Cell[BoxData[{
    \( (*\ \(===\)\(\(>\)\(\ \)\(Input\ von\ Hand\)\)\ *) \[IndentingNewLine]\
\ n = 8; d[1] = deklin[20, 12]; d[2] = deklin[1, 2]; d[3] = deklin[1, 3]; 
    d[4] = deklin[17.805, 3]; d[5] = deklin[1, 5]; d[6] = deklin[1, 6]; 
    d[7] = deklin[21, 6]; 
    d[8] = deklin[29, 
        8];\[IndentingNewLine] (*\ \(===\)\(\(>\)\(\ \)\(Listengenerierung\ \
mit\ dem\ Input\)\)\ *) \), "\[IndentingNewLine]", 
    \(\(dlist[n_] := Table[d[k], {k, 1, n}];\)\), "\[IndentingNewLine]", 
    \(dlist[n]\)}], "Input"],

Cell[BoxData[
    \( (*\ \(===\)\(\(>\)\(\ \)\(Plot\ der\ Liste\)\)\ *) \)], "Input"],

Cell[BoxData[
    \(dekPlot[dlist[n], 1, \(-5\), 5, \(-1\), 4, 0]\)], "Input"],

Cell[BoxData[
    \(dekPlot[dlist[n], 1, \(-5\), 5, \(-1\), 4, 1]\)], "Input"],

Cell[BoxData[
    \(dekPlot[dlist[n], 0, \(-5\), 5, \(-4\), 1, 1]\)], "Input"],

Cell[BoxData[
    \(zeitSchlaufen[dlist[7], 2, 
      7, {\(-3.5\), 3.5}, {\(-4\), 1.2}, {\(-3\), 3}]\)], "Input"],

Cell[BoxData[
    \(zeitSchlaufen[dlist[7], 0, 
      7, {\(-3.5\), 3.5}, {\(-4\), 1.2}, {\(-3\), 3}]\)], "Input"],

Cell[BoxData[
    \(zeitSchlaufen[dlist[7], 1, 
      7, {\(-3.5\), 3.5}, {\(-1.2\), 4}, {\(-3\), 3}]\)], "Input"],

Cell[BoxData[
    \(newPositionWithPrint[30, 6, \[CurlyPhi]]\)], "Input"],

Cell[BoxData[
    \(newPosition[30, 6, \[CurlyPhi]]\)], "Input"],

Cell[BoxData[
    \(drehOmbrixDekSlPlot[{\(-7\), 2}, {\(-4\), 4}, {\(-4\), 4}, {1, 8}, {0, 
        0}, {\(-4\), 2}, {4, 5}, {6, 7}, {\(-7\), 2}]\)], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1152}, {0, 791}},
WindowToolbars->"EditBar",
WindowSize->{553, 697},
WindowMargins->{{Automatic, 103}, {Automatic, -13}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 49, 0, 105, "Title"],
Cell[1791, 53, 93, 2, 53, "Subsubtitle"],

Cell[CellGroupData[{
Cell[1909, 59, 61, 0, 53, "Section"],
Cell[1973, 61, 214, 5, 50, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2224, 71, 210, 5, 116, "Section"],
Cell[2437, 78, 35233, 604, 8990, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37707, 687, 113, 3, 74, "Section"],

Cell[CellGroupData[{
Cell[37845, 694, 198, 4, 85, "Subsection"],

Cell[CellGroupData[{
Cell[38068, 702, 57, 0, 43, "Subsubsection"],
Cell[38128, 704, 35, 1, 30, "Input"],
Cell[38166, 707, 54, 1, 30, "Input"],
Cell[38223, 710, 51, 1, 30, "Input"],
Cell[38277, 713, 68, 1, 30, "Input"],
Cell[38348, 716, 49, 1, 30, "Input"],
Cell[38400, 719, 48, 1, 30, "Input"],
Cell[38451, 722, 67, 1, 30, "Input"],
Cell[38521, 725, 63, 1, 30, "Input"],
Cell[38587, 728, 73, 1, 30, "Input"],
Cell[38663, 731, 73, 1, 30, "Input"],
Cell[38739, 734, 67, 1, 30, "Input"],
Cell[38809, 737, 88, 1, 30, "Input"],
Cell[38900, 740, 67, 1, 30, "Input"],
Cell[38970, 743, 48, 1, 30, "Input"],
Cell[39021, 746, 74, 1, 30, "Input"],
Cell[39098, 749, 563, 9, 170, "Input"],
Cell[39664, 760, 40, 1, 30, "Input"],
Cell[39707, 763, 53, 1, 30, "Input"],
Cell[39763, 766, 55, 1, 30, "Input"],
Cell[39821, 769, 65, 1, 30, "Input"],
Cell[39889, 772, 168, 2, 70, "Input"],
Cell[40060, 776, 45, 1, 30, "Input"],
Cell[40108, 779, 46, 1, 30, "Input"],
Cell[40157, 782, 80, 1, 30, "Input"],
Cell[40240, 785, 34, 1, 30, "Input"],
Cell[40277, 788, 48, 1, 30, "Input"],
Cell[40328, 791, 129, 2, 30, "Input"],
Cell[40460, 795, 157, 3, 70, "Input"],
Cell[40620, 800, 44, 1, 30, "Input"],
Cell[40667, 803, 524, 9, 150, "Input"],
Cell[41194, 814, 85, 1, 30, "Input"],
Cell[41282, 817, 78, 1, 30, "Input"],
Cell[41363, 820, 78, 1, 30, "Input"],
Cell[41444, 823, 78, 1, 30, "Input"],
Cell[41525, 826, 114, 2, 50, "Input"],
Cell[41642, 830, 114, 2, 50, "Input"],
Cell[41759, 834, 114, 2, 50, "Input"],
Cell[41876, 838, 73, 1, 30, "Input"],
Cell[41952, 841, 64, 1, 30, "Input"],
Cell[42019, 844, 158, 2, 50, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

